/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.init.datagen;

import codechicken.lib.datagen.recipe.AbstractItemStackRecipeBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import morph.avaritia.init.AvaritiaModContent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompressorRecipeBuilder
extends AbstractItemStackRecipeBuilder<CompressorRecipeBuilder> {
    private static final Logger LOGGER = LogManager.getLogger();
    private int cost;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

    protected CompressorRecipeBuilder(RecipeSerializer<?> serializer, ResourceLocation id, ItemStack result) {
        super(serializer, id, result);
    }

    public static CompressorRecipeBuilder builder(ItemLike result) {
        return CompressorRecipeBuilder.builder(result, 1);
    }

    public static CompressorRecipeBuilder builder(ItemLike result, int count) {
        return CompressorRecipeBuilder.builder(new ItemStack(result, count));
    }

    public static CompressorRecipeBuilder builder(ItemLike result, int count, ResourceLocation id) {
        return CompressorRecipeBuilder.builder(new ItemStack(result, count), id);
    }

    public static CompressorRecipeBuilder builder(ItemStack result) {
        return CompressorRecipeBuilder.builder(result, result.m_41720_().getRegistryName());
    }

    public static CompressorRecipeBuilder builder(ItemStack result, ResourceLocation id) {
        return new CompressorRecipeBuilder((RecipeSerializer)AvaritiaModContent.DEFAULT_COMPRESSOR_RECIPE.get(), id, result);
    }

    public CompressorRecipeBuilder cost(int cost) {
        this.cost = cost;
        return this;
    }

    public CompressorRecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(tag, 1);
    }

    public CompressorRecipeBuilder addIngredient(TagKey<Item> tag, int quantity) {
        this.addAutoCriteria(tag);
        Ingredient ingredient = Ingredient.m_204132_(tag);
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public CompressorRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(item, 1);
    }

    public CompressorRecipeBuilder addIngredient(ItemLike item, int quantity) {
        this.addAutoCriteria(item);
        Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public CompressorRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public CompressorRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        if (this.generateCriteria) {
            LOGGER.warn("Criteria not automatically generated for raw ingredient.", new Throwable("Here, have a stack trace"));
        }
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public FinishedCompressorRecipe _build() {
        return new FinishedCompressorRecipe();
    }

    public class FinishedCompressorRecipe
    extends AbstractItemStackRecipeBuilder.AbstractItemStackFinishedRecipe {
        public FinishedCompressorRecipe() {
            super((AbstractItemStackRecipeBuilder)CompressorRecipeBuilder.this);
        }

        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            json.addProperty("cost", (Number)CompressorRecipeBuilder.this.cost);
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingredient : CompressorRecipeBuilder.this.ingredients) {
                ingredients.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredients);
        }
    }
}

